define([
    'marionette',
    'models/external-links-collection', 
    'json!externalLinksJson',
    'models/resources-collection', 
    'json!../test/spec_helpers/resource-directory.json',
    'json!featureFlagJson',
    'modules/loading-spinner/loading-spinner'

], function (
    Marionette, 
    ExternalLinks, 
    externalLinksJson, 
    Resources, 
    resourceDirectory, 
    FeatureFlagJson,
    spinner
) {
    var app = new Marionette.Application();

    spinner.register = _.noop;

    app.disabledFeatures = new Backbone.Model();
    app.configurations = new Backbone.Model();
    app.externalLinks = new ExternalLinks(externalLinksJson, {parse: true});
    app.resources = new Resources(resourceDirectory, {parse: true});
    app.patientEnrolledFacilities = new Backbone.Collection();
    app.userSession = new Backbone.Model();
    app.facilities = new Backbone.Collection([{facilityCode: '100'}, {facilityCode: '200'}]);
    app.patientIdentifiers = new Backbone.Collection();
    app.ccTypeOfCares = new Backbone.Collection();
    app.ccEligibilityModel = new Backbone.Model({isCcEligible: function() {
        return;
    }});
    app.isCcEligFeatureEnabled = function () {
        var jsonModel = new Backbone.Model(FeatureFlagJson);
        var featureFlagExists = jsonModel.has('CC_ELIG_SERVICE_DISABLED');
        var ccEligFeatureIsDisabledFlag = jsonModel.get('CC_ELIG_SERVICE_DISABLED');
        if (_.isUndefined(this.disabledFeatures.get('CC_FEATURE_SET'))) {
            // CC feature is enabled, so check for the Elig feature setting in Consul
            return (featureFlagExists && !ccEligFeatureIsDisabledFlag);
        }
        return false; // default - eligibility feature is not enabled
    }

    return app;
});

